﻿namespace Microsoft.Samples.PlanMyNight.Data.Caching
{
    using System;
    using Microsoft.Data.Caching;

    public class VelocityProvider : ICachingProvider
    {
        private readonly DataCacheFactory cacheFactory;

        public VelocityProvider()
        {
            this.cacheFactory = new DataCacheFactory();
        }

        public bool HasKey(string container, string key)
        {
            try
            {
                var cacheContainer = this.cacheFactory.GetCache(container);
                return cacheContainer.Get(key) != null;
            }
            catch (DataCacheException ex)
            {
                if (ex.ErrorCode == DataCacheErrorCode.RetryLater)
                {
                    // temporal failure, ignore and continue
                    return false;
                }

                throw;
            }
        }

        public object Get(string container, string key)
        {
            try
            {
                var cacheContainer = this.cacheFactory.GetCache(container);
                return cacheContainer.Get(key);
            }
            catch (DataCacheException ex)
            {
                if (ex.ErrorCode == DataCacheErrorCode.RetryLater)
                {
                    // temporal failure, ignore and continue
                    return null;
                }

                throw;
            }
        }

        public void Add(string container, string key, object value, TimeSpan timeout)
        {
            if (value == null) return;

            try
            {
                var cacheContainer = this.cacheFactory.GetCache(container);
                cacheContainer.Put(key, value, timeout);
            }
            catch (DataCacheException ex)
            {
                if (ex.ErrorCode == DataCacheErrorCode.RetryLater)
                {
                    // temporal failure, ignore and continue
                    return;
                }

                throw;
            }
        }

        public void Remove(string container, string key)
        {
            try
            {
                var cacheContainer = this.cacheFactory.GetCache(container);
                cacheContainer.Remove(key);
            }
            catch (DataCacheException ex)
            {
                if (ex.ErrorCode == DataCacheErrorCode.KeyDoesNotExist)
                {
                    return;
                }

                throw;
            }
        }
    }
}
